<?php
session_start();

// Password for editing
$password = "changeme";
$file = "waitlist.csv.php";

// Check if user is authenticated
if (!isset($_SESSION['authenticated']) && isset($_POST['password'])) {
    if ($_POST['password'] === $password) {
        $_SESSION['authenticated'] = true;
    }
}

// Handle logout
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: index.php");
    exit;
}

// Handle form submissions
if (isset($_SESSION['authenticated']) && $_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_entry'])) {
        $data = array_map('trim', [
            getNextWaitlistNumber($file),
            $_POST['first_name'],
            $_POST['last_name'],
            $_POST['contact'],
            date('Ymd'),
            $_POST['request_date'],
            $_POST['priority'],
            $_POST['computer_ready'],
            $_POST['inventory_id'],
            $_POST['computer_desc'],
            $_POST['computer_os'],
            $_POST['picked_up'],
            $_POST['pickup_date'],
            $_POST['need_desc'],
            $_POST['notes']
        ]);
        $fp = fopen($file, 'a');
        fputs($fp, implode(',', $data) . "\n");
        fclose($fp);
    }
    
    if (isset($_POST['delete_entry'])) {
        $content = file_get_contents($file);
        $lines = preg_split('/\r\n|\r|\n/', trim($content));
        $lines = array_filter($lines);
        $fp = fopen($file, 'w');
        foreach ($lines as $line) {
            $row = explode(',', $line);
            if ($row[0] !== $_POST['waitlist_number']) {
                fputs($fp, $line . "\n");
            }
        }
        fclose($fp);
    }

    if (isset($_POST['edit_entry'])) {
        $content = file_get_contents($file);
        $lines = preg_split('/\r\n|\r|\n/', trim($content));
        $lines = array_filter($lines);
        $fp = fopen($file, 'w');
        foreach ($lines as $line) {
            $row = explode(',', $line);
            if ($row[0] === $_POST['waitlist_number']) {
                $updated_data = [
                    $_POST['waitlist_number'],
                    $_POST['first_name'],
                    $_POST['last_name'],
                    $_POST['contact'],
                    $_POST['store_date'],
                    $_POST['request_date'],
                    $_POST['priority'],
                    $_POST['computer_ready'],
                    $_POST['inventory_id'],
                    $_POST['computer_desc'],
                    $_POST['computer_os'],
                    $_POST['picked_up'],
                    $_POST['pickup_date'],
                    $_POST['need_desc'],
                    $_POST['notes']
                ];
                fputs($fp, implode(',', $updated_data) . "\n");
            } else {
                fputs($fp, $line . "\n");
            }
        }
        fclose($fp);
    }
}

// Function to get next waitlist number
function getNextWaitlistNumber($file) {
    if (!file_exists($file)) return 1;
    $content = file_get_contents($file);
    $lines = preg_split('/\r\n|\r|\n/', trim($content));
    $lines = array_filter($lines);
    if (empty($lines)) return 1;
    $last_line = explode(',', end($lines));
    return intval($last_line[0]) + 1;
}

// Calculate statistics
function getWaitlistStats($file) {
    $stats = [
        'total_waitlist CHEMICALS' => 0,
        'laptops_provided' => 0,
        'avg_rate' => 0,
        'first_pickup' => 'N/A',
        'last_pickup' => 'N/A'
    ];
    
    if (!file_exists($file)) return $stats;
    
    $content = file_get_contents($file);
    $lines = preg_split('/\r\n|\r|\n/', trim($content));
    $lines = array_filter($lines);
    $provided = 0;
    $pickup_dates = [];
    $date_formats = ['m/d/y', 'Y-m-d', 'Ymd']; // Supported date formats

    foreach ($lines as $line) {
        $row = explode(',', $line);
        if (!isset($row[11], $row[12])) continue; // Skip if pickup status or date is missing
        if ($row[11] === 'N') $stats['total_waitlist']++;
        if ($row[11] === 'Y' && !empty($row[12])) {
            $provided++;
            $pickup_date = false;
            // Try parsing date in multiple formats
            foreach ($date_formats as $format) {
                $date = DateTime::createFromFormat($format, trim($row[12]));
                if ($date && $date->format($format) === trim($row[12])) {
                    $pickup_date = $date;
                    break;
                }
            }
            if ($pickup_date) {
                $pickup_dates[] = $pickup_date;
            }
        }
    }
    
    $stats['laptops_provided'] = $provided;
    if (!empty($pickup_dates)) {
        // Find earliest and latest dates
        $earliest_date = min($pickup_dates);
        $latest_date = max($pickup_dates);
        $days_diff = $latest_date->diff($earliest_date)->days;
        if ($days_diff > 0) {
            $months_diff = $days_diff / 30.44;
            $stats['avg_rate'] = round($provided / $months_diff, 2);
        }
        $stats['first_pickup'] = $earliest_date->format('m/d/y');
        $stats['last_pickup'] = $latest_date->format('m/d/y');
    }

    return $stats;
}

// Handle CSV download
if (isset($_GET['download']) && isset($_SESSION['authenticated']) && file_exists($file)) {
    $timestamp = date('Ymd-His');
    $download_filename = "{$timestamp}-waitlist.csv";
    header('Content-Type: text/csv');
    header("Content-Disposition: attachment; filename=\"{$download_filename}\"");
    readfile($file);
    exit;
}

// Handle Report CSV download
if (isset($_GET['report']) && isset($_SESSION['authenticated']) && file_exists($file)) {
    $timestamp = date('Ymd-His');
    $download_filename = "{$timestamp}-waitlist-report.csv";
    header('Content-Type: text/csv');
    header("Content-Disposition: attachment; filename=\"{$download_filename}\"");
    
    $content = file_get_contents($file);
    $lines = preg_split('/\r\n|\r|\n/', trim($content));
    $lines = array_filter($lines);
    
    $report_data = [];
    $date_formats = ['m/d/y', 'Y-m-d', 'Ymd'];
    foreach ($lines as $line) {
        $row = explode(',', $line);
        if (!isset($row[11], $row[12], $row[13])) continue;
        if ($row[11] === 'Y' && !empty($row[12])) {
            $pickup_date = false;
            foreach ($date_formats as $format) {
                $date = DateTime::createFromFormat($format, trim($row[12]));
                if ($date && $date->format($format) === trim($row[12])) {
                    $pickup_date = $date;
                    break;
                }
            }
            if ($pickup_date) {
                $report_data[] = [
                    'date' => $pickup_date,
                    'formatted_date' => $pickup_date->format('m/d/y'),
                    'need_desc' => $row[13]
                ];
            }
        }
    }
    
    // Sort by pickup date
    usort($report_data, function($a, $b) {
        return $a['date'] <=> $b['date'];
    });
    
    // Calculate days since last pickup
    $output = "Days Since Last Pickup,Pickup Date,Need Description\n";
    $last_date = null;
    foreach ($report_data as $entry) {
        $days_diff = $last_date ? $entry['date']->diff($last_date)->days : 0;
        $output .= "$days_diff,{$entry['formatted_date']},\"{$entry['need_desc']}\"\n";
        $last_date = $entry['date'];
    }
    
    echo $output;
    exit;
}

$stats = getWaitlistStats($file);
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laptop Ministry Waitlist</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <div class="radio-bar">
        <span>Laptop Ministry Waitlist</span>
        <div class="share-options">
            <?php if (file_exists($file) && isset($_SESSION['authenticated'])): ?>
                <a href="?download=1">Download Full CSV</a>
                <a href="?report=1">Download Report</a>
                <a href="?logout=1">Logout</a>
            <?php endif; ?>
        </div>
    </div>

    <?php if (!isset($_SESSION['authenticated'])): ?>
        <div class="popup" style="display:block;">
            <div class="popup-content">
                <h3>Enter Password</h3>
                <form method="post">
                    <input type="password" name="password" required>
                    <button type="submit">Login</button>
                </form>
                <h4>Waitlist Statistics</h4>
                <p>People on Waitlist: <?php echo $stats['total_waitlist']; ?></p>
                <p>Laptops Provided: <?php echo $stats['laptops_provided']; ?></p>
                <p>Avg. Receivership Rate: <?php echo $stats['avg_rate']; ?> laptops/month</p>
                <p>First Laptop Pickup: <?php echo $stats['first_pickup']; ?></p>
                <p>Last Laptop Pickup: <?php echo $stats['last_pickup']; ?></p>
            </div>
        </div>
    <?php else: ?>
        <h1>Laptop Ministry Waitlist</h1>
        
        <!-- Add New Entry Form -->
        <form method="post">
            <h3>Add New Entry</h3>
            <input type="text" name="first_name" placeholder="First Name" required>
            <input type="text" name="last_name" placeholder="Last Name" required>
            <input type="text" name="contact" placeholder="Contact" required>
            <input type="date" name="request_date" required>
            <select name="priority">
                <option value="N">Priority: No</option>
                <option value="Y">Priority: Yes</option>
            </select>
            <select name="computer_ready">
                <option value="N">Computer Ready: No</option>
                <option value="Y">Computer Ready: Yes</option>
            </select>
            <input type="text" name="inventory_id" placeholder="Inventory ID#">
            <input type="text" name="computer_desc" placeholder="Computer Description">
            <input type="text" name="computer_os" placeholder="Computer OS">
            <select name="picked_up">
                <option value="N">Picked Up: No</option>
                <option value="Y">Picked Up: Yes</option>
            </select>
            <input type="date" name="pickup_date">
            <textarea name="need_desc" placeholder="Description of Need"></textarea>
            <textarea name="notes" placeholder="Notes"></textarea>
            <button type="submit" name="add_entry">Add Entry</button>
        </form>
        <!-- Display Existing Entries -->
        <?php if (file_exists($file)): ?>
            <h2>Current Waitlist</h2>
            <table>
                <tr>
                    <th>#</th><th>First</th><th>Last</th><th>Contact</th><th>Store Date</th>
                    <th>Request Date</th><th>Prio</th><th>Ready</th><th>ID#</th>
                    <th>Desc</th><th>OS</th><th>Picked Up</th><th>Pickup Date</th>
                    <th>Need</th><th>Notes</th><th>Actions</th>
                </tr>
                <?php
                $content = file_get_contents($file);
                $lines = preg_split('/\r\n|\r|\n/', trim($content));
                $lines = array_filter($lines);
                foreach ($lines as $line) {
                    $row = explode(',', $line);
                    echo "<tr>";
                    for ($i = 0; $i < 15; $i++) {
                        echo "<td>" . htmlspecialchars($row[$i] ?? '') . "</td>";
                    }
                    echo "<td>";
                    echo "<form method='post' style='display:inline;'>
                        <input type='hidden' name='waitlist_number' value='{$row[0]}'>
                        <button type='submit' name='delete_entry'>Delete</button>
                        </form>";
                    echo "<form method='get' style='display:inline;'>
                        <input type='hidden' name='edit' value='{$row[0]}'>
                        <button type='submit'>Edit</button>
                        </form>";
                    echo "</td>";
                    echo "</tr>";
                }
                ?>
            </table>

            <!-- Edit Form -->
            <?php if (isset($_GET['edit'])): ?>
                <?php
                $edit_number = $_GET['edit'];
                $content = file_get_contents($file);
                $lines = preg_split('/\r\n|\r|\n/', trim($content));
                $lines = array_filter($lines);
                $edit_row = null;
                foreach ($lines as $line) {
                    $row = explode(',', $line);
                    if ($row[0] === $edit_number) {
                        $edit_row = $row;
                        break;
                    }
                }
                if ($edit_row):
                ?>
                    <div id="edit-form" class="popup" style="display:block;">
                        <div class="popup-content">
                            <h3>Edit Entry #<?php echo htmlspecialchars($edit_row[0]); ?></h3>
                            <form method="post">
                                <input type="hidden" name="waitlist_number" value="<?php echo htmlspecialchars($edit_row[0]); ?>">
                                <input type="hidden" name="store_date" value="<?php echo htmlspecialchars($edit_row[4]); ?>">
                                <input type="text" name="first_name" value="<?php echo htmlspecialchars($edit_row[1]); ?>" required>
                                <input type="text" name="last_name" value="<?php echo htmlspecialchars($edit_row[2]); ?>" required>
                                <input type="text" name="contact" value="<?php echo htmlspecialchars($edit_row[3]); ?>" required>
                                <input type="date" name="request_date" value="<?php echo date('Y-m-d', strtotime($edit_row[5])); ?>" required>
                                <select name="priority">
                                    <option value="N" <?php if ($edit_row[6] === 'N') echo 'selected'; ?>>Priority: No</option>
                                    <option value="Y" <?php if ($edit_row[6] === 'Y') echo 'selected'; ?>>Priority: Yes</option>
                                </select>
                                <select name="computer_ready">
                                    <option value="N" <?php if ($edit_row[7] === 'N') echo 'selected'; ?>>Computer Ready: No</option>
                                    <option value="Y" <?php if ($edit_row[7] === 'Y') echo 'selected'; ?>>Computer Ready: Yes</option>
                                </select>
                                <input type="text" name="inventory_id" value="<?php echo htmlspecialchars($edit_row[8]); ?>">
                                <input type="text" name="computer_desc" value="<?php echo htmlspecialchars($edit_row[9]); ?>">
                                <input type="text" name="computer_os" value="<?php echo htmlspecialchars($edit_row[10]); ?>">
                                <select name="picked_up">
                                    <option value="N" <?php if ($edit_row[11] === 'N') echo 'selected'; ?>>Picked Up: No</option>
                                    <option value="Y" <?php if ($edit_row[11] === 'Y') echo 'selected'; ?>>Picked Up: Yes</option>
                                </select>
                                <input type="date" name="pickup_date" value="<?php echo $edit_row[12] ? date('Y-m-d', strtotime($edit_row[12])) : ''; ?>">
                                <textarea name="need_desc"><?php echo htmlspecialchars($edit_row[13]); ?></textarea>
                                <textarea name="notes"><?php echo htmlspecialchars($edit_row[14]); ?></textarea>
                                <button type="submit" name="edit_entry">Save Changes</button>
                            </form>
                        </div>
                    </div>
                <?php else: ?>
                    <p>Debug: No matching row found for waitlist number <?php echo htmlspecialchars($edit_number); ?></p>
                <?php endif; ?>
            <?php endif; ?>
        <?php endif; ?>
    <?php endif; ?>

    <footer>
        <p>Laptop Ministry Waitlist System - <?php echo date('Y'); ?> by Page Telegram Volunteer Services for The Peoples Church of Chicago</p>
    </footer>

    <?php if (isset($_GET['edit'])): ?>
    <script>
        window.location.hash = 'edit-form';
    </script>
    <?php endif; ?>
</body>
</html>
